<?php
	$this->load->library('printer');
	$this->load->library('enletras');
	
	$phpPrinter = new Printer();
	$phpInletters = new EnLetras();
	
	$phpPrinter->resetAcum();
	$acum = 0;
	
	/*Init*/
	$printer = printer_open("EPSON TM-U950 Slip CCF");

	printer_set_option($printer, PRINTER_MODE, 'RAW');

	printer_start_doc($printer, 'Factura Numero: '.$doc_numero);

	printer_start_page($printer);
	
	/*Body*/
	
	$font = printer_create_font('Arial', 9, 7, PRINTER_FW_THIN, false, false, false, 0);	
	printer_select_font($printer, $font);
	
	/*Ghost*/
	$phpPrinter->printString(strtoupper(utf8_decode(substr(" ",0,24))),2,$printer,$acum,13,11,70);
	$phpPrinter->tabPrinter($acum,75);
	
	$fecha = explode("-",$fecha);
	$fechadia = explode(" ",$fecha[0]);
	$phpPrinter->printString($fechadia[0],2,$printer,$acum,13,11,560);
	$phpPrinter->printString($fecha[1],2,$printer,$acum,13,0,610);
	$phpPrinter->printString($fecha[2],2,$printer,$acum,13,0,660);
	$phpPrinter->tabPrinter($acum,15);
	$phpPrinter->printString(strtoupper(utf8_decode($cliente)),2,$printer,$acum,13,11,160);
	$phpPrinter->tabPrinter($acum,10);
	$phpPrinter->printString(strtoupper(utf8_decode(substr($direccion_cliente,0,20))),2,$printer,$acum,13,11,160);
	//$phpPrinter->printString(strtoupper(utf8_decode(substr($vendedor,0,10))),2,$printer,$acum,13,0,585);
	$phpPrinter->tabPrinter($acum,58);
	
	/*Body*/
	foreach($productos_normal as $producto){
		$phpPrinter->printString($producto->cant,2,$printer,$acum,9,7,90);
		$phpPrinter->printString($phpPrinter->cutString(strtoupper(utf8_decode(addslashes($producto->desc))),26),2,$printer,$acum,9,0,160);
		$phpPrinter->printString($producto->costo,2,$printer,$acum,9,0,515);
		$phpPrinter->printString($producto->cant * $producto->costo,2,$printer,$acum,9,0,715);
		$phpPrinter->tabPrinter($acum,3);
	}
	
	/*Footer*/
	printer_draw_text($printer,$phpInletters->ValorEnLetras($totales['totalTotal'],""), 130, 400);
	printer_draw_text($printer,"Ref:".$referencia, 80, 410);
	if($condicion=="Credito"){
		printer_draw_text($printer,"Credito a:".$diascred." dias", 300, 410);
	}
	printer_draw_text($printer,$totales['totalGrabadas'], 715, 400);
	printer_draw_text($printer,$totales['totalGrabadas'], 715, 415);
	printer_draw_text($printer,$totales['totalExento'], 715, 440);
	printer_draw_text($printer,$totales['totalNS'], 715, 455);
	printer_draw_text($printer,$totales['totalTotal'], 715, 495);
	
	printer_delete_font($font);
	
	printer_end_page($printer);

	printer_end_doc($printer);

	printer_close($printer);
?>